<?php
/**
 * Trainer moderation connector
 * Путь: assets/components/coaches/connector.php
 */

define('MODX_API_MODE', true);

/* ───────────────────────────────────────────────────────────
   Подключаем MODX: поднимаемся на 3 уровня до `/public_html`
   /assets/components/coaches  →  /assets  →  /public_html
   ─────────────────────────────────────────────────────────── */
require dirname(__DIR__, 3) . '/index.php';

$modx->initialize('mgr');
header('Content-Type: application/json; charset=utf-8');

/* Только админ (user ID = 1) */
if (!$modx->user || $modx->user->get('id') != 1) {
    exit(json_encode(['success' => false, 'message' => 'Недостаточно прав']));
}

$action = $_POST['action'] ?? '';
$ids    = array_filter(array_map('intval', explode(',', $_POST['ids'] ?? '')));

switch ($action) {

    /* ------------------------------------------------------------------ */
    case 'sendEmail':
        $subject = trim($_POST['subject'] ?? 'Информация');
        $body    = trim($_POST['body'] ?? '');
        $sent    = 0;

        foreach ($ids as $rid) {
            /** @var modResource $res */
            if (!$res = $modx->getObject('modResource', $rid)) {
                continue;
            }

            /* 1. В TV хранится ID пользователя или e-mail */
            $userField = trim($res->getTVValue('setCreatedBy'));

            if (is_numeric($userField)) {
                $profile = $modx->getObject('modUserProfile', ['internalKey' => (int)$userField]);
                $email   = $profile ? trim($profile->get('email')) : '';
            } else {
                $email = $userField;
            }

            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                continue;   // пропускаем, если e-mail невалиден
            }

            /** @var modPHPMailer $mail */
            $mail = $modx->getService('mail', 'mail.modPHPMailer');
            $mail->set(modMail::MAIL_FROM,      $modx->getOption('emailsender'));
            $mail->set(modMail::MAIL_FROM_NAME, $modx->getOption('site_name', null, 'Administration'));
            $mail->address('to', $email);
            $mail->set(modMail::MAIL_SUBJECT, $subject);
            $mail->set(modMail::MAIL_BODY,    nl2br($body));
            $mail->setHTML(true);

            if ($mail->send()) {
                $sent++;
            }
            $mail->reset();
        }

        echo json_encode(['success' => true, 'message' => 'Отправлено писем: ' . $sent]);
        break;

    /* ------------------------------------------------------------------ */
    case 'setStatus':
        $status = (int)($_POST['status'] ?? 0);
        foreach ($ids as $rid) {
            if ($res = $modx->getObject('modResource', $rid)) {
                $res->setTVValue('status', $status);
            }
        }
        $modx->cacheManager->refresh();
        echo json_encode(['success' => true, 'message' => 'Статус обновлён']);
        break;

    /* ------------------------------------------------------------------ */
    case 'setParent':
        $parent = (int)($_POST['parent'] ?? 0);
        foreach ($ids as $rid) {
            if ($res = $modx->getObject('modResource', $rid)) {
                $res->set('parent', $parent);
                $res->save();
            }
        }
        $modx->cacheManager->refresh();
        echo json_encode(['success' => true, 'message' => 'Родитель изменён']);
        break;

    /* ------------------------------------------------------------------ */
    default:
        echo json_encode(['success' => false, 'message' => 'Неизвестное действие']);
}

?>